<?php
class Core_Validate_Stringlength extends Core_Validate_Abstract
{
    // default error message
    protected $_defaultErrorMessage = 'Unos mora biti između %min% i %max% znakova';

    protected $_min;
    protected $_max;

    protected function _isValid($value)
    {
        $isValid = true;

        // verify params
        $min = $this->getMin();
        $max = $this->getMax();

        if (!($min || $max)) {
            throw new Core_Validate_Exception(sprintf('Validator %s requires at least one param, "min" or "max"', get_class($this)));
        } else {
            $strlen = iconv_strlen($value);

            if ($min && $strlen < (int) $min) {
                $isValid = false;
            } else if ($max && $strlen > (int) $max) {
                $isValid = false;
            }
        }

        return $isValid;
    }

    public function setMin($min)
    {
        $this->_min = (float) $min;
    }

    public function getMin()
    {
        return $this->_min;
    }

    public function setMax($max)
    {
        $this->_max = (float) $max;
    }

    public function getMax()
    {
        return $this->_max;
    }

    public function getAngularRepresentation($errorMessage = null)
    {
        $representation = array();
        if (null !== ($min = $this->getMin())) {
            $representation += $this->_formatAngularRepresentation('minlength', $errorMessage, $min, 'ng-minlength');
        }
        if (null !== ($max = $this->getMax())) {
            $representation += $this->_formatAngularRepresentation('maxlength', $errorMessage, $max, 'ng-maxlength');
        }
        return $representation;
    }
}