<?php
class Core_Validate_Regex extends Core_Validate_Abstract
{
    protected $_angularType = 'pattern';

    // default error message
    protected $_defaultErrorMessage = 'Vrijednost ne odgovara zadanom predlošku';

    protected $_regex;

    protected function _isValid($value)
    {
        // fetch the regex
        $regex = $this->getRegex();
        if (empty($regex) || !is_string($regex)) {
            throw new Core_Validate_Exception(sprintf('Validator %s requires exactly one param, a valid regex', get_class($this)));
        }

        return (bool) preg_match($regex, $value);
    }

    public function getAngularRepresentation($errorMessage = null)
    {
        return $this->_formatAngularRepresentation($this->_angularType, $errorMessage, $this->getRegex());
    }

    public function setRegex($regex)
    {
        $this->_regex = $regex;
        return $this;
    }

    public function getRegex()
    {
        return $this->_regex;
    }
}