<?php
class Core_Validate_Phone extends Core_Validate_Regex
{
    // default error message
    protected $_defaultErrorMessage = '%value% nije valjan format telefona';

    protected $_pattern = array(
        // possible area code with leading + or 00
        '((\+|00)?[0-9]{3})?',

        // city code with trailing spaces, slash or dash
        '([ \-]{0,}[0-9]{2,3}[ ]{0,3}[\-/]?[ \-]{0,})?',

        // first numbers
        '([0-9]{3,4}[ \-]{0,3})',

        // last numbers
        '([0-9]{3,4})'
    );

    protected $_regex;

    public function getRegex()
    {
        if (null === $this->_regex) {
            $this->_regex = '@^'. implode('', $this->_pattern) .'$@';
        }

        return $this->_regex;
    }
}