<?php
class Core_Validate_Oembeddable extends Core_Validate_Abstract
{
    // default error message
    protected $_defaultErrorMessage = 'Nije moguće umetnuti ovaj resurs';

    // valid oEmbed types, default to none
    protected $_types = array();

    protected $_oembedClient;

    protected function _isValid($value)
    {
        $this->setValue($value);

        $oembedClient = $this->getOembedClient();
        $oembed       = $oembedClient->get($value);

        // is this even a valid oembed resource?
        if (empty($oembed)) {
            // nope
            return false;
        }

        // is it of valid type?
        return in_array($oembed->type, $this->getTypes());
    }

    public function setOembedClient(Oembed $oembedClient)
    {
        $this->_oembedClient = $oembedClient;
        return $this;
    }

    public function getOembedClient()
    {
        if (null === $this->_oembedClient) {
            $this->_oembedClient = Core_Application::get('OembedClient');
        }
        return $this->_oembedClient;
    }

    public function setTypes($types)
    {
        $this->_types = (array) $types;
        return $this;
    }

    public function getTypes()
    {
        return $this->_types;
    }
}