<?php
/**
 * core.framework
 *
 * @category  Core
 * @package   Core_Validate
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */

/**
 * Validates if a value is empty or not.
 *
 * @category   Core
 * @package    Core_Validate
 * @subpackage NotEmpty
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */
class Core_Validate_Notempty extends Core_Validate_Abstract
{
    /**
     * @var string
     */
    protected $_defaultErrorMessage = 'Neophodno!';

    /**
     * @var string
     */
    protected $_angularType = 'required';

    /**
     * @param mixed $value Value to evaluate.
     *
     * @return boolean
     */
    protected function _isValid($value)
    {
        // any int or float will do (even 0 or 0.0)
        if (is_int($value) || is_float($value)) {
            return true;
        } else if (is_string($value)) {
            if ('' === trim($value)) {
                // string containing only whitespace characters is considered empty
                return false;
            } else {
                return true;
            }
        }

        // everything else we let PHP's empty() decide
        return !empty($value);
    }
}