<?php
class Core_Validate_Min extends Core_Validate_Abstract
{
    protected $_angularType = 'min';

    // default error message
    protected $_defaultErrorMessage = 'Vrijednost je manja od %min%';

    protected $_min;

    protected function _isValid($value)
    {
        return ($value >= $this->getMin());
    }

    public function setMin($min)
    {
        $this->_min = (float) $min;
    }

    public function getMin()
    {
        return $this->_min;
    }

    public function getAngularRepresentation($errorMessage = null)
    {
        return $this->_formatAngularRepresentation($this->_angularType, $errorMessage, $this->getMin());
    }
}