<?php
class Core_Validate_Max extends Core_Validate_Abstract
{
    protected $_angularType = 'max';

    // default error message
    protected $_defaultErrorMessage = 'Vrijednost je veća od %max%';

    protected $_max;

    protected function _isValid($value)
    {
        return ($value <= $this->getMax());
    }

    public function setMax($max)
    {
        $this->_max = (float) $max;
    }

    public function getMax()
    {
        return $this->_max;
    }

    public function getAngularRepresentation($errorMessage = null)
    {
        return $this->_formatAngularRepresentation($this->_angularType, $errorMessage, $this->getMax());
    }
}