<?php
class Core_Validate_Identical extends Core_Validate_ElementsAbstract
{
    // default error message
    protected $_defaultErrorMessage = 'Vrijednosti se ne podudaraju';

    protected function _isValid($value)
    {
        // fetch names of elements to be identical to
        $elements = (Array) $this->getElements();
        if (empty($elements)) {
            throw new Core_Validate_Exception(sprintf('Validator %s requires param "elements", names of elements to be identical to', get_class($this)));
        }

        $isValid = true;
        $context = $this->getContext();
        foreach ($elements as $element) {
            $isValid = ($isValid && isset($context[$element]) && ($context[$element] == $value));
        }

        return $isValid;
    }
}