<?php
class Core_Validate_File_Size extends Core_Validate_File_Abstract
{
    protected $_size;

    protected $_types        = array();
    protected $_errorMessage = 'Datoteka je prevelika, najveća moguća je %size% byteova';

    protected function _isValid($file)
    {
        return ($file->getSize() <= $this->getSize());
    }

    public function setSize($size)
    {
        $this->_size = Core_Util::stringToBytes($size);
        return $this;
    }

    public function getSize()
    {
        return $this->_size;
    }
}