<?php
class Core_Validate_File_ImageSize extends Core_Validate_File_Abstract
{
    const MODE_LESS          = '<';
    const MODE_LESS_EQUAL    = '<=';
    const MODE_EXACT         = '==';
    const MODE_GREATER       = '>';
    const MODE_GREATER_EQUAL = '>=';

    protected $_mode         = self::MODE_LESS_EQUAL;

    protected $_width        = 0;
    protected $_height       = 0;
    protected $_errorMessage = 'Datoteka nije ispravnog tipa, prihvaćamo %types%';

    protected function _isValid($file)
    {
        $path   = $file->getPath();
        $width  = $this->getWidth();
        $height = $this->getHeight();

        /** TODO: comparison by mode */
        $mode   = $this->getMode();

        $info   = getimagesize($path);

        if (null !== $width && $width != $info[0]) {
            return false;
        } else if (null !== $height && $height != $info[1]) {
            return false;
        }

        return true;
    }

    public function setMode($mode)
    {
        $this->_mode = $mode;
        return $this;
    }

    public function getMode()
    {
        return $this->_mode;
    }

    public function setWidth($width)
    {
        $this->_width = (int) $width;
        return $this;
    }

    public function getWidth()
    {
        return $this->_width;
    }

    public function setHeight($height)
    {
        $this->_height = (int) $height;
        return $this;
    }

    public function getHeight()
    {
        return $this->_height;
    }
}