<?php
class Core_Validate_Email extends Core_Validate_Regex
{
    protected $_angularType = 'email';

    // default error message
    protected $_defaultErrorMessage = 'Neispravan email';

    // an e-mail regex
    protected $_regex = '/^[A-Za-z0-9](([_\.\-\+]?[a-zA-Z0-9_]+)*)@([A-Za-z0-9]+)(([\.\-]?[a-zA-Z0-9]+)*)\.([A-Za-z]{2,})$/';

    public function getAngularRepresentation($errorMessage = null)
    {
        return $this->_formatAngularRepresentation($this->_angularType, $errorMessage, $this->_angularConfig);
    }
}