<?php
class Core_Validate_Divisible extends Core_Validate_Abstract
{
    protected $_defaultErrorMessage = 'Vrijednost nije djeljiva s %divider%';

    protected $_divider;

    protected function _isValid($value)
    {
        $divider = $this->getDivider();

        // only check dividability if divider != 0.0 (float)
        return (0.0 !== $divider ?  (0 === $value % $divider) : false);
    }

    public function setDivider($divider)
    {
        $this->_divider = (float) $divider;
    }

    public function getDivider()
    {
        return $this->_divider;
    }
}