<?php
class Core_Validate_Date extends Core_Validate_Abstract
{
    // default error message
    protected $_defaultErrorMessage = 'Vrijednost nije valjani datum';

    protected $_format = 'd.m.Y.';

    protected function _isValid($value)
    {
        $format = $this->getFormat();
        $date   = date_parse_from_format($format, $value);

        if ($date && (isset($date['year']) && isset($date['month']) && isset($date['day']))) {
            return checkdate($date['month'], $date['day'], $date['year']);
        }
        return false;
    }

    public function setFormat($format)
    {
        $this->_format = $format;
        return $this;
    }

    public function getFormat()
    {
        return $this->_format;
    }
}