<?php
class Core_Validate_Array_Min extends Core_Validate_Array_Abstract
{
    protected $_angularType = 'min';

    protected $_defaultErrorMessage = 'Premalo stavaka';

    protected $_min;

    protected function _isValid($value)
    {
        return (count($value) >= $this->getMin());
    }

    public function setMin($min)
    {
        $this->_min = (float) $min;
    }

    public function getMin()
    {
        return $this->_min;
    }

    public function getAngularRepresentation($errorMessage = null)
    {
        $representation  = $this->_formatAngularRepresentation('required', $errorMessage);
        $representation += $this->_formatAngularRepresentation($this->_angularType, $errorMessage, $this->getMin());
        return $representation;
    }
}