<?php
class Core_Validate_Array_Max extends Core_Validate_Array_Abstract
{
    protected $_angularType = 'max';

    protected $_defaultErrorMessage = 'Previše stavaka';

    protected $_max;

    protected function _isValid($value)
    {
        return (count($value) <= $this->getMax());
    }

    public function setMax($max)
    {
        $this->_max = (float) $max;
    }

    public function getMax()
    {
        return $this->_max;
    }

    public function getAngularRepresentation($errorMessage = null)
    {
        return $this->_formatAngularRepresentation($this->_angularType, $errorMessage, $this->getMax());
    }
}