<?php
/**
 * core.framework
 *
 * @category  Core
 * @package   Core_Util
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */

/**
 * The temporary place to... well, place functionality until better place is found.
 *
 * @category  Core
 * @package   Core_Util
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_Util
{
    /**
     * @var array
     */
    static protected $_powers = array(
        'k' => 10,
        'm' => 20,
        'g' => 30,
        't' => 40,
    );

    /**
     * Debug vars
     *
     * @var array
     */
    static protected $_debug = array();

    /**
     * Format string like "2k" to bytes (2048)
     *
     * @param string $val
     *
     * @return int Number of bytes
     */
    static public function stringToBytes($val)
    {
        $val   = trim($val);
        $unit  = strtolower(substr($val, -1));

        if (isset(self::$_powers[$unit])) {
            $power = self::$_powers[$unit];
            $val  *= pow(2, $power);
        }

        return $val;
    }

    /**
     * Store vars for debug console
     *
     * @param mixed $var
     * @param string $line
     * @param int $user_id
     */
    static public function debug($var, $line = null, $user_id = null) {
        if (Core_Application::getInstance()->getEnvironment() !== 'development') {
            return;
        }

        if (null === $user_id) {
            global $user;
            $user_id = $user->get_user_id();
        }

        self::$_debug[] = array(
            'var'   => print_r($var, true),
            'line'  => $line,
            'user'  => (int) $user_id
        );
    }

    /**
     * Get debug variables
     *
     * @return array
     */
    static public function getDebugVars() {
        return self::$_debug;
    }
}