<?php
/**
 * core.framework
 *
 * @category  Core
 * @package   Core_User
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */

/**
 * @category  Core
 * @package   Core_User
 * @subpackage Core_User_Storage
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_User_Storage_Session extends Core_Session implements Zend_Auth_Storage_Interface
{
    protected $_member = 'auth_storage';

    public function clear()
    {
        $this->del($this->_member);
    }

    public function isEmpty()
    {
        return $this->get($this->_member) === null;
    }

    public function read()
    {
        return $this->get($this->_member);
    }

    public function write($contents)
    {
        $this->set($this->_member, $contents);
    }

}