<?php
class Core_Twig_Extensions_Extension_Translate extends Twig_Extension
{
    static public $pluralForms = array(
        // which count will trigger new plural form, per locale
        // Made to cover cases of plural functions defined in lib/Zend/Translate/Plural.php
        'bo'    => array(1),
        'dz'    => array(1),
        'id'    => array(1),
        'ja'    => array(1),
        'jv'    => array(1),
        'ka'    => array(1),
        'km'    => array(1),
        'kn'    => array(1),
        'ko'    => array(1),
        'ms'    => array(1),
        'th'    => array(1),
        'tr'    => array(1),
        'vi'    => array(1),
        'zh'    => array(1),
        'af'    => array(1, 2),
        'az'    => array(1, 2),
        'bn'    => array(1, 2),
        'bg'    => array(1, 2),
        'ca'    => array(1, 2),
        'da'    => array(1, 2),
        'de'    => array(1, 2),
        'el'    => array(1, 2),
        'en'    => array(1, 2),
        'eo'    => array(1, 2),
        'es'    => array(1, 2),
        'et'    => array(1, 2),
        'eu'    => array(1, 2),
        'fa'    => array(1, 2),
        'fi'    => array(1, 2),
        'fo'    => array(1, 2),
        'fur'   => array(1, 2),
        'fy'    => array(1, 2),
        'gl'    => array(1, 2),
        'gu'    => array(1, 2),
        'ha'    => array(1, 2),
        'he'    => array(1, 2),
        'hu'    => array(1, 2),
        'is'    => array(1, 2),
        'it'    => array(1, 2),
        'ku'    => array(1, 2),
        'lb'    => array(1, 2),
        'ml'    => array(1, 2),
        'mn'    => array(1, 2),
        'mr'    => array(1, 2),
        'nah'   => array(1, 2),
        'nb'    => array(1, 2),
        'ne'    => array(1, 2),
        'nl'    => array(1, 2),
        'nn'    => array(1, 2),
        'no'    => array(1, 2),
        'om'    => array(1, 2),
        'or'    => array(1, 2),
        'pa'    => array(1, 2),
        'pap'   => array(1, 2),
        'ps'    => array(1, 2),
        'pt'    => array(1, 2),
        'so'    => array(1, 2),
        'sq'    => array(1, 2),
        'sv'    => array(1, 2),
        'sw'    => array(1, 2),
        'ta'    => array(1, 2),
        'te'    => array(1, 2),
        'tk'    => array(1, 2),
        'ur'    => array(1, 2),
        'zu'    => array(1, 2),
        'am'    => array(1, 2),
        'bh'    => array(1, 2),
        'fil'   => array(1, 2),
        'fr'    => array(1, 2),
        'gun'   => array(1, 2),
        'hi'    => array(1, 2),
        'ln'    => array(1, 2),
        'mg'    => array(1, 2),
        'nso'   => array(1, 2),
        'xbr'   => array(1, 2),
        'ti'    => array(1, 2),
        'wa'    => array(1, 2),
        'be'    => array(1, 2, 5),
        'bs'    => array(1, 2, 5),
        'hr'    => array(1, 2, 5),
        'ru'    => array(1, 2, 5),
        'sr'    => array(1, 2, 5),
        'uk'    => array(1, 2, 5),
        'cs'    => array(1, 2, 5),
        'sk'    => array(1, 2, 5),
        'ga'    => array(1, 2, 3),
        'lt'    => array(1, 2, 11),
        'sl'    => array(1, 2, 3, 5),
        'mk'    => array(1, 2),
        'mt'    => array(1, 2, 11, 20),
        'lv'    => array(0, 1, 2),
        'pl'    => array(1, 2, 13),
        'cy'    => array(1, 2, 8, 9),
        'ro'    => array(1, 2, 20),
        'ar'    => array(0, 1, 2, 3, 11, 100),
    );

    public function getFunctions()
    {
        return array(
            'trans'  => new Twig_Function_Function('core_translate_string', array('is_safe' => array('html'))),
            'ptrans' => new Twig_Function_Function('core_translate_string_plural', array('is_safe' => array('html'))),
            'atrans' => new Twig_Function_Function('core_translate_angular_plural', array('is_safe' => array('html'))),
        );
    }

    /**
     * Returns a list of filters to add to the existing list.
     *
     * @return array An array of filters
     */
    public function getFilters()
    {
        return array(
            'trans'  => new Twig_Filter_Function('core_translate_string'),
            'ptrans' => new Twig_Filter_Function('core_translate_string_plural'),
            'atrans' => new Twig_Filter_Function('core_translate_angular_plural'),
        );
    }

    /**
     * Returns the name of the extension.
     *
     * @return string The extension name
     */
    public function getName()
    {
        return 'translate';
    }
    
    public function translate($message)
    {
        return $message;
    }
}

function core_translate_string($message)
{
    // singular or plural?
    $translator = Core_Application::get('translator');
    $message    = $translator->translate($message);
    return $message;
}

function core_translate_string_plural($message, $pluralMessage, $count, $format = true)
{
    // singular or plural?
    $translator   = Core_Application::get('translator');
    $translation  = $translator->translate(array($message, $pluralMessage, $count));
    if (true === $format) {
        // inject the value
        $translation = sprintf($translation, $count);
    }
    return $translation;
}

function core_translate_angular_plural($message, $pluralMessage, $variable, $format = 'service')
{
    $translator   = Core_Application::get('translator');
    $locale       = $translator->getLocale();
    if (!array_key_exists($locale, Core_Twig_Extensions_Extension_Translate::$pluralForms)) {
        throw new RuntimeException(sprintf('No plural forms specified for locale "%s"', $locale));
    }
    $forms        = Core_Twig_Extensions_Extension_Translate::$pluralForms[$locale];
    $translations = array();
    foreach ($forms as $count) {
        $translations[] = core_translate_string_plural($message, $pluralMessage, $count, false);
    }
    
    switch ($format) {
        // TODO: other formats if required
        default:
        case 'service':
            $output = sprintf('pluralization.pluralize(%1$s, %2$s)', json_encode($translations), $variable);
            break;
    }
    return $output;
}