<?php
class Core_Twig_Extensions_Extension_Numeric extends Twig_Extension
{
    /**
     * Returns a list of filters.
     *
     * @return array
     */
    public function getFilters()
    {
        return array(
            'floor'     => new Twig_Filter_Function('floor'),
            'ceil'      => new Twig_Filter_Function('ceil'),
            'round'     => new Twig_Filter_Function('round'),
            'format'    => new Twig_Filter_Function('number_format'),
            'price'     => new Twig_Filter_Method($this, 'price', array('is_safe' => array('html'))),
        );
    }

    /**
     * Create price string
     *
     * @param float $amount
     * @param boolean $currency
     *
     * @return string
     */
    public function price($amount, $currency = 'kn')
    {
        $amount = number_format($amount, 2, ',', '.');
        if ($currency) {
            return $amount .'&nbsp;'. $currency;
        } else {
            return $amount;
        }
    }

    /**
     * Name of this extension
     *
     * @return string
     */
    public function getName()
    {
        return 'Core_Twig_Numeric';
    }
}