<?php
class Core_Twig_Extensions_Extension_Asset extends Twig_Extension
{
    /**
     * Returns a list of functions.
     *
     * @return array
     */
    public function getFunctions()
    {
        return array(
            new Twig_SimpleFunction('assets', array($this, 'core_twig_assets')),
            'dumpFile'      => new Twig_Function_Function('file_get_contents'),
        );
    }

    /**
     *
     * @param   array   $paths
     * @param   array   $options
     * @return  array
     */
    public function core_twig_assets(array $paths, array $options = null)
    {
        $assets = Core_Application::get('assetManager')->process($paths, $options);

        foreach ($assets as $asset) {
            $assetUrls[]    = $asset;
        }

        return $assetUrls;
    }
    /**
     * Name of this extension
     *
     * @return string
     */
    public function getName()
    {
        return 'Core_Twig_Asset';
    }
}
