<?php
/**
 * core.framework
 *
 * @category  Core
 * @package   Core_Storage
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */

/**
 * @category  Core
 * @package   Core_Storage
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
interface Core_Storage_Strategy_Interface
{
    /**
     * @param \Core_Storage_File|Core_File|string $file
     *
     * @returns boolean
     */
    public function has($file);

    /**
     * @param \Core_Storage_File|Core_File|string $file
     *
     * @returns \Core_Storage_File
     */
    public function fetch($file);

    /**
     * @param \Core_Storage_File|Core_File|string $file
     *
     * @returns \Core_Storage_File
     */
    public function store($file);

    /**
     * @param \Core_Storage_File|Core_File|string $file
     *
     * @returns boolean
     */
    public function remove($file);

    /**
     * @param string $path
     *
     * @returns $string
     */
    public function createFileUrl($path);

    /**
     * @param string $path
     *
     * @returns $string
     */
    public function createFileUrlPath($path);

    /**
     * @param string $path
     *
     * @returns $string
     */
    public function createFilePath($path);
}
