<?php

abstract class Core_Singleton
{

    /**
     * @return Core_Singleton[]
     */
    protected static $instances = array();

    protected function __construct()
    {

    }

    /**
     * @return Core_Singleton
     */
    public static function getInstance()
    {
        if (!isset(static::$instances[get_called_class()])) {
            static::$instances[get_called_class()] = new static;
        }

        return static::$instances[get_called_class()];
    }
} 