<?php

/**
 * core.framework
 *
 * @category  Core
 * @package   Core_Session
 * @copyright Copyright (c) 2013. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */

/**
 * @category  Core
 * @package   Core_Session
 * @copyright Copyright (c) 2013. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_Session
{
    protected $_namespace;
    protected $_singleInstance;
    protected $_sessionNamespace;
    protected $_options = array();

    public function __construct($namespace = 'Default', $singleInstance = false, array $options = null)
    {
        $this->_namespace = $namespace;
        $this->_singleInstance = $singleInstance;

        if (null !== $options) {
            $this->_options = $options;
        }
    }

    /**
     *
     * @return Zend_Session_Namespace
     */
    public function _getSessionNamespace()
    {
        if (null === $this->_sessionNamespace) {
            Zend_Session::setOptions($this->_options);

            $this->_sessionNamespace = new Zend_Session_Namespace($this->_namespace, $this->_singleInstance);
        }

        return $this->_sessionNamespace;
    }

    /**
     *
     * @param string $name
     * @return mixed
     */
    public function get($name)
    {
        return $this->_getSessionNamespace()->$name;
    }

    /**
     *
     * @param string $name
     * @param mixed $value
     */
    public function set($name, $value)
    {
        $this->_getSessionNamespace()->$name = $value;
    }

    /**
     *
     * @param string $name
     *
     * @return string
     */
    public function del($name)
    {
        $value = $this->get($name);
        unset($this->_getSessionNamespace()->$name);

        return $value;
    }

    /**
     * @return string
     */
    public function getId()
    {
        $this->_getSessionNamespace();
        return Zend_Session::getId();
    }
}
