<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Router
 * @subpackage Route
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Router
 * @subpackage Route
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */
class Core_Router_Route_Static extends Core_Router_Route_Abstract
{
    /**
     * @param string  $separator Will be ignored
     * @param array   $params    Will be ignored
     *
     * @return string Assembled path.
     */
    public function path($separator, $params = array())
    {
        $path = $this->getBase() . $this->getPattern();
        return $this->_appendQuery($path, $params);
    }

    /**
     * Examine if this route matches a path (in the global routing process)
     *
     * @param string $path      Path against we match the route against
     * @param string $separator Use this as the path separator
     *
     * @return bool True if route matches path, false otherwise.
     */
    protected function _match($path, $separator)
    {
        $pattern   = rtrim($this->getPattern(), $separator);
        $path      = rtrim($path, $separator);
        return (0 === strcasecmp($pattern, $path));
    }
}