<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Router
 * @subpackage Route
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Router
 * @subpackage Route
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */
class Core_Router_Route_Plugin_Rest extends Core_Router_Route_Plugin_Abstract
{
    /**
     * @var array
     */
    protected $_headersRequest = array(
        'Accept',
        'Method',
        'Origin',
    );

    /**
     * @param array $values  Values to match against
     * @param array $request Request headers to inspect
     *
     * @return mixed
     */
    protected function _match(array $values, array $request = null)
    {
        if (isset($values['id'])) {
            $action = '%1$sOne';
            if (isset($values['relation'])) {
                $action .= $values['relation'];
            }
        } else {
            $action = '%1$s';
        }
        
        $routeValues = array(
            'action' => sprintf($action, strtolower($request['Method'])),
        );
        if (isset($values['entity'])) {
            $routeValues['entity'] = $values['entity'];
        }
        return $routeValues;
    }
}
