<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Router
 * @subpackage Route
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Router
 * @subpackage Route
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */
class Core_Router_Route_Plugin_Model extends Core_Router_Route_Plugin_Abstract
{
    /**
     * @var string
     */
    protected $_component;

    /**
     * @var array
     */
    protected $_map = array();

    /**
     * @var Core_Router_Route_Plugin_Model_Interface
     */
    protected $_model;

    /**
     * Will skip "model" option
     *
     * @param array $options
     *
     * @return Core_Router_Route_Plugin_Model
     *
     * @throws InvalidArgumentException
     */
    public function setOptions(array $options)
    {
        if (isset($options['model'])) {
            unset($options['model']);
        }

        return parent::setOptions($options);
    }

    /**
     * @param string $component
     *
     * @return \Core_Router_Route_Plugin_Model
     */
    public function setComponent($component)
    {
        $this->_component = $component;
        return $this;
    }

    /**
     * @return string
     */
    public function getComponent()
    {
        if (null === $this->_component) {
            throw new InvalidArgumentException('Failed fetching component name, no component name set');
        }
        return $this->_component;
    }

    /**
     * @param array $map
     *
     * @return \Core_Router_Route_Plugin_Model
     */
    public function setMap(array $map)
    {
        $this->_map = $map;
        return $this;
    }

    /**
     * @return array
     */
    public function getMap()
    {
        return $this->_map;
    }

    /**
     * @param Core_Router_Route_Plugin_Model_Interface $model
     *
     * @return \Core_Router_Route_Plugin_Model
     */
    public function setModel(Core_Router_Route_Plugin_Model_Interface $model)
    {
        $this->_model = $model;
        return $this;
    }

    /**
     * @return Core_Router_Route_Plugin_Model_Interface
     */
    public function getModel()
    {
        if (null === $this->_model) {
            $model = Core_Application::get($this->getComponent());
            if (!$model instanceof Core_Router_Route_Plugin_Model_Interface) {
                throw new InvalidArgumentException(sprintf(
                    'Failed fetching named component %s for Model plugin, '
                  . 'component must be an instance of Core_Router_Route_Plugin_Model_Interface',
                    $this->getComponent()
                ));
            }
            $this->setModel($model);
        }
        return $this->_model;
    }

    /**
     * @param array $values  Values to match against
     * @param array $request Ignored
     *
     * @return mixed
     */
    protected function _match(array $values, array $request = null)
    {
        if (($map = $this->getMap())) {
            $newValues = array();
            foreach($map as $old => $new) {
                $newValues[$new] = (array_key_exists($old, $values) ? $values[$old] : null);
            }
            $values = $newValues;
        }
        
        $response = $this->getModel()->match($values);
        return $response;
    }
}
