<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Router
 * @subpackage Route
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * The route interface.
 *
 * @category   Core
 * @package    Core_Router
 * @subpackage Route
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */
interface Core_Router_Route_Plugin_Interface
{
    /**
     * @return string
     */
    public function getName();

    /**
     * @return array
     */
    public function getHeadersRequest();

    /**
     * @param array $values  Values to match against
     * @param array $request Misc request values to parse
     *
     * @return bool True if values match defined presets, false otherwise
     */
    public function match(array $values, array $request = null);

    /**
     * @param Core_Router_Route_Interface $route
     *
     * @return Core_Router_Route_Plugin_Interface
     */
    public function setRoute(Core_Router_Route_Interface $route);
}
