<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Router
 * @subpackage Route
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * The route abstract.
 *
 * @category   Core
 * @package    Core_Router
 * @subpackage Route
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */
abstract class Core_Router_Route_Plugin_Abstract implements Core_Router_Route_Plugin_Interface
{
    /**
     * @var string
     */
    protected $_name;

    /**
     * @var array
     */
    protected $_headersRequest = array();

    /**
     * @var Core_Router_Route_Interface
     */
    protected $_route;

    /**
     * @param array $values  Values to match against
     * @param array $request Ignored
     *
     * @return mixed
     */
    abstract protected function _match(array $values, array $request = null);

    /**
     * @param array $options
     */
    public function __construct(array $options = null)
    {
        if (is_array($options)) {
            $this->setOptions($options);
        }
    }

    /**
     * @return array
     */
    public function getHeadersRequest()
    {
        return $this->_headersRequest;
    }

    /**
     * @param array $values  Values to match against
     * @param array $request Ignored
     *
     * @return bool True if values match defined presets, false otherwise
     */
    public function match(array $values, array $request = null)
    {
        if (is_array($request)) {
            $headers  = $this->getHeadersRequest();
            $supplied = array_keys($request);
            $diff     = array_diff($headers, $supplied);
            if ($diff) {
                $msg = sprintf('Failed matching route, missing requested headers (%s)', implode(',', $diff));
                throw new InvalidArgumentException($msg);
            }
        }

        $response = $this->_match($values, $request);
        if (is_array($response)) {
            // store model response to route as values
            $this->getRoute()->addValues($response);
        }

        return (bool) $response;
    }

    /**
     * @param string $name
     *
     * @return \Core_Router_Route_Plugin_Abstract
     */
    public function setName($name)
    {
        $this->_name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->_name;
    }

    /**
     * @param Core_Router_Route_Interface $name
     *
     * @return \Core_Router_Route_Plugin_Abstract
     */
    public function setRoute(Core_Router_Route_Interface $route)
    {
        $this->_route = $route;
        return $this;
    }

    /**
     * @return Core_Router_Route_Interface
     */
    public function getRoute()
    {
        return $this->_route;
    }

    /**
     * @param array $options
     *
     * @return Core_Router_Route_Plugin_Abstract
     * @throws InvalidArgumentException
     */
    public function setOptions(array $options)
    {
        foreach ($options as $key => $value) {
            $normalized = ucfirst($key);

            $callable = array($this, 'set' . $normalized);
            if (is_callable($callable)) {
                call_user_func($callable, $value);
            } else {
                throw new InvalidArgumentException(sprintf('Invalid option "%s" passed', $key));
            }
        }
        return $this;
    }
}
