<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Router
 * @subpackage Route
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * The route interface.
 *
 * @category   Core
 * @package    Core_Router
 * @subpackage Route
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */
interface Core_Router_Route_Interface
{
    /**
     * @param Core_Router $router
     *
     * @return Core_Router_Route_Interface
     */
    public function setRouter(Core_Router $router);

    /**
     * @param string $pattern Route pattern in format fitting the type
     *
     * @return Core_Router_Route_Interface
     */
    public function setPattern($pattern);

    /**
     * Examine if this route matches a path (in the global routing process)
     *
     * @param string $path      Path against we match the route against
     * @param string $separator Use this as the path separator
     * @param string $method    If set, the request method (GET, POST, etc.) must also match for the route to match
     * @param string $hostname  If set, the current hostname must match the specified hostname.
     *
     * @return bool True if route matches path, false otherwise.
     */
    public function match($path, $separator, $method = null, $hostname = null);

    /**
     * Generate a path matching this route.
     *
     * @param string $separator Use this as the path separator
     * @param array  $params    Values to use when generating a route
     *
     * @return string Path matching route and params
     */
    public function path($separator, $params = null);

    /**
     * Generate an URL matching this route.
     *
     * @param string $separator Use this as the path separator
     * @param array  $params    Values to use when generating a route
     *
     * @return string URL matching route and params
     */
    public function url($separator, $params = null);

    /**
     * Set route value
     *
     * @param string $name
     * @param string $value
     *
     * @return \Core_Router_Route_Interface
     */
    public function setValue($name, $value);

    /**
     * @param string $name
     *
     * @return \Core_Router_Route_Interface
     */
    public function removeValue($name);
    /**
     * Add route values
     *
     * @param array Values merged to route values.
     *
     * @return Core_Router_Route_Interface
     */
    public function addValues(array $values);

    /**
     * Get route values.
     *
     * @return array Values from route, defaults overwritten by input.
     */
    public function getValues();
}
