<?php
/**
 * core.framework
 *
 * @category  Core
 * @package   Core_QueryLanguage
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */

/**
 * Query Language. Manages Core_QueryLanguage_Query and adapters
 *
 * @category  Core
 * @package   Core_QueryLanguage
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_QueryLanguage
{
    /**
     *
     * @var Core_QueryLanguage_Query
     */
    protected $_query;

    /**
     *
     * @var Core_QueryLanguage_Adapter_Interface[]
     */
    protected $_adapters = array();

    /**
     *
     * @param Core_QueryLanguage_Query|string $query
     */
    public function __construct($query)
    {
        $this->setQuery($query);
    }

    /**
     *
     * @return Core_QueryLanguage_Query
     */
    public function getQuery()
    {
        return $this->_query;
    }

    /**
     *
     * @param Core_QueryLanguage_Query|string|array $query
     *
     * @return \Core_QueryLanguage
     */
    public function setQuery($query)
    {
        if (!($query instanceof Core_QueryLanguage_Query)) {
            $query = Core_QueryLanguage_Query::factory($query);
        }

        $this->_query = $query;

        return $this;
    }

    /**
     * Set adapter
     *
     * @param string $name
     * @param Core_QueryLanguage_Adapter_Interface $adapter
     *
     * @return \Core_QueryLanguage
     */
    public function setAdapter($name, Core_QueryLanguage_Adapter_Interface $adapter)
    {
        $this->_adapters[$name] = $adapter;

        return $this;
    }

    /**
     * Get adapter
     *
     * @param string $name
     *
     * @return Core_QueryLanguage_Adapter_Interface
     * @throws RuntimeException
     */
    public function getAdapter($name)
    {
        if (!isset($this->_adapters[$name])) {
            throw new RuntimeException('Error while getting adapter with name '. $name .', it is not set');
        }

        return $this->_adapters[$name]->setQuery($this->getQuery());
    }

}
