<?php
class Core_Log_Formatter_Simple extends Zend_Log_Formatter_Simple
{

    /**
     * @var Core_Request
     */
    protected $_request;
    
    /**
     * @var Core_Application
     */
    protected $_application;

    /**
     * @param Core_Application $application
     *
     * @return Core_Application
     */
    public function setApplication(Core_Application $application)
    {
        $this->_application = $application;
        return $this;
    }

    /**
     * If not set, set Core_Application
     *
     * @return Core_Application
     */
    public function getApplication()
    {
        if (null === $this->_application) {
            $this->setApplication(Core_Application::getInstance());
        }
        return $this->_application;
    }

    /**
     * @param Core_Request $request
     *
     * @return Core_Router
     */
    public function setRequest(Core_Request $request)
    {
        $this->_request = $request;
        return $this;
    }

    /**
     * If not set, fetch from Core_Application
     *
     * @return Core_Request
     */
    public function getRequest()
    {
        if (null === $this->_request) {
            $this->setRequest(Core_Application::get('Request'));
        }
        return $this->_request;
    }

    /**
     * Formats data into a single line to be written by the writer.
     *
     * @param  array    $event    event data
     * @return string             formatted line to write to the log
     */
    public function format($event)
    {
        $output             = $this->_format;

        foreach ($event as $name => $value) {
            if ((is_object($value) && !method_exists($value,'__toString'))
                || is_array($value)
            ) {
                $value = gettype($value);
            }

            $output = str_replace("%$name%", $value, $output);
        }


        $out            = "***************************************************\n";
        $out            .= $output;

        $type           = 'php';
        if ($event['message'] instanceof Core_Exception_Interface) {
            $exception  = $event['message'];
            $type       = $exception->getType();
        }

        $lang           = $this->getApplication()->getLanguage();
        $env            = $this->getApplication()->getEnvironment();
        $clientIp       = $this->getRequest()->getClientIp();
        $method         = $this->getRequest()->getMethod();
        $referrer       = $this->getRequest()->getReferrer();
        $path           = $this->getRequest()->getPath();
        $uri            = $this->getRequest()->getUriBase();
        
        $out            .= "Type: $type, Environment: $env, Language: $lang, Uri: $uri, Path: $path, "
                            ."Method: $method, Referrer: $referrer, ClientIP: $clientIp\n";

        return $out;
    }
}