<?php
/**
 * core.framework
 *
 * @category  Core
 * @package   Core_Log_Filter_Throttle
 * @copyright Copyright (c) 2013. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */

/**
 * @category  Core
 * @package   Core_Log_Filter_Throttle
 * @copyright Copyright (c) 2013. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_Log_Filter_Throttle extends Zend_Log_Filter_Abstract
{
    /**
     * @var Zend_Cache_Core
     */
    protected $_cache;

    /**
     * Exception expiry time
     * @var int
     */
    protected $_expiryTime;         // 1 hour

    public function __construct($expiryTime = 86400)            // 24 hours
    {
        $this->setExpiryTime($expiryTime);
    }

    /**
     * Create a new instance of Core_Log_Filter_Throttle
     *
     * @param  array|Zend_Config $config
     * @return Core_Log_Filter_Throttle
     */
    static public function factory($config)
    {
        $config = self::_parseConfig($config);
        $config = array_merge(array(
            'expiryTime' => null
        ), $config);

        return new self($config['expiryTime']);
    }

    /**
     * Throttle event or not?
     *
     * @param array $event
     */
    public function accept($event)
    {
        // accept objects, arrays and strings as events
        $errorMessage   = $event['message'];

        $token          = md5($errorMessage);
        $tokenCounter   = $token . 'counter';
        $tokenData      = $this->getCache()->load($token);

        // don't log by default
        $throttle = false;

        if (empty($tokenData)) {

            // Fresh exception, save it to cache
            $newTokenData = 1;

            $this->getCache()->save($newTokenData, $token, array(), $this->getExpiryTime());
            $counter = $this->getCache()->load($tokenCounter);

            $throttle   = true;
            $counter    = 1;

        } else {

            // dohvati counter
            $counter = (int) $this->getCache()->load($tokenCounter);
            $counter++;

        }
        $this->getCache()->save($counter, $tokenCounter, array(), 2592000);

        return $throttle;
    }

    public function setCache(Zend_Cache_Core $cache)
    {
        $this->_cache = $cache;
        return $this;
    }

    public function getCache()
    {
        if (null === $this->_cache) {
            $this->setCache(Core_Application::get('cacheManager')->getDefaultCache());
        }
        return $this->_cache;
    }

    /**
     * Set exception expiry time
     *
     * @param   int   $duration
     * @throws  ErrorException
     */
    public function setExpiryTime($duration)
    {
        if (!is_integer($duration)) {
            throw new InvalidArgumentException('Duration must be an integer in seconds: '. $duration);
        }
        $this->_expiryTime = $duration;
        return $this;
    }

    /**
     * Get exception expiry time
     *
     * @return int
     */
    public function getExpiryTime()
    {
        return $this->_expiryTime;
    }
}