<?php
class Core_Log extends Zend_Log
{
    protected $_severityToPriority;

    protected $_throttler;

    public function __construct(Zend_Log_Writer_Abstract $writer = null)
    {
        $this->_severityToPriority = array(
            E_ERROR             => Zend_Log::EMERG,
            E_PARSE             => Zend_Log::EMERG,
            E_WARNING           => Zend_Log::WARN,
            E_DEPRECATED        => Zend_Log::WARN,
            E_STRICT            => Zend_Log::WARN,
            E_NOTICE            => Zend_Log::NOTICE,
            E_CORE_ERROR        => Zend_Log::EMERG,
            E_CORE_WARNING      => Zend_Log::WARN,
            E_COMPILE_ERROR     => Zend_Log::EMERG,
            E_COMPILE_WARNING   => Zend_Log::WARN,
            E_USER_ERROR        => Zend_Log::EMERG,
            E_USER_WARNING      => Zend_Log::WARN,
            E_USER_DEPRECATED   => Zend_Log::WARN,
            E_USER_NOTICE       => Zend_Log::NOTICE,
            E_RECOVERABLE_ERROR => Zend_Log::ALERT,
        );

        parent::__construct($writer);
    }

    public function log($message, $priority, $extras = null)
    {
        // figure out the severity of the exception
        if ($message instanceof ErrorException) {
            $priority = $this->_mapSeverityToPriority($message->getSeverity());
        }

        return parent::log($message, $priority, $extras);
    }

    protected function _mapSeverityToPriority($severity)
    {
        return $this->_severityToPriority[$severity];
    }
}