<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category  Core
 * @package   Core_Form
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_Form_Group_Collection extends Core_Form_Entity_Collection
{
    /**
     * @var array
     */
    protected $_mandatoryAttribs = array(
        Core_Form::CONTEXT_DEFAULT => array('id' => 'fullyQualifiedId', 'data-next-index' => 'nextIndex', 'data-marker' => 'prototypeMarker'),
        Core_Form::CONTEXT_ANGULAR => array('id' => 'fullyQualifiedAngularId', 'ng-model' => 'fullyQualifiedAngularModel', 'name'),
    );

    /**
     * @var string
     */
    protected $_macro = 'collection';

    /**
     * @var string
     */
    protected $_type = 'group';

    /**
     * @var string
     */
    protected $_prototypeType = 'group';

    /**
     * @var string
     */
    protected $_getItemsMethod = 'getGroups';

    /**
     * @var string
     */
    protected $_getItemMethod  = 'getGroup';

    /**
     * @var string
     */
    protected $_hasItemMethod  = 'hasGroup';

    /**
     * @var string
     */
    protected $_addItemMethod  = 'addGroup';

    /**
     * @var string
     */
    protected $_removeItemMethod  = 'removeGroup';

    /**
     * @var string
     */
    protected $_createItemMethod  = 'createGroup';

    /**
     * @return array
     */
    public function getGroups()
    {
        return $this->_getItems();
    }

    /**
     * @param int $idx
     *
     * @return Core_Form_Group_Interface
     */
    public function getGroup($idx)
    {
        return $this->_getItem($idx);
    }
    
    /**
     * @param string $context
     *
     * @return array
     */
    public function getAttribs($context = null)
    {
        $attribs = array_merge($this->_getDefaultAttribs($context), $this->_attribs);
        $attribs = $this->_mergeMandatoryValues($attribs, $this->_mandatoryAttribs[$context]);
        if (Core_Form::CONTEXT_ANGULAR === $context) {
            $attribs = array_merge($attribs, $this->getAngularRepresentation(true));
        }
        return $attribs;
    }
}
