<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category  Core
 * @package   Core_Form
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
abstract class Core_Form_Element_Wysiwyg extends Core_Form_Element_Textarea
{
    /**
     * @var string
     */
    protected $_configComponent;

    /**
     * @var string
     */
    protected $_preset     = 'default';

    /**
     * @var string
     */
    protected $_presetName = 'preset';

    /**
     * @var string
     */
    protected $_wysiwygType;

    /**
     * @var array
     */
    protected $_wysiwygOptions;

    /**
     * @param array $wysiwygOptions
     *
     * @return \Core_Form_Element_Wysiwyg
     */
    public function setWysiwygOptions(array $wysiwygOptions)
    {
        $this->_wysiwygOptions = $wysiwygOptions;
        return $this;
    }

    /**
     * @return array
     */
    public function getWysiwygOptions()
    {
        if (null === $this->_wysiwygOptions) {
            $wysiwygParams  = array($this->_presetName => $this->getPreset());
            $wysiwygOptions = Core_Application::get($this->_configComponent, $wysiwygParams);

            if ($wysiwygOptions instanceof Zend_Config) {
                $wysiwygOptions = $wysiwygOptions->toArray();
            }

            $this->setWysiwygOptions($wysiwygOptions);
        }
        return $this->_wysiwygOptions;
    }

    /**
     * @param string $preset
     *
     * @return \Core_Form_Element_Wysiwyg
     */
    public function setPreset($preset)
    {
        $this->_preset = $preset;
        return $this;
    }

    /**
     * @return string
     */
    public function getPreset()
    {
        return $this->_preset;
    }

    /**
     * @param string $context
     *
     * @return array
     */
    protected function _getDefaultAttribs($context)
    {
        $attribs = parent::_getDefaultAttribs($context);
        return array_merge($attribs, array($this->_wysiwygType => json_encode($this->getWysiwygOptions())));
    }
}
