<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category  Core
 * @package   Core_Form
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_Form_Element_Textarea extends Core_Form_Element_Abstract
{
    /**
     * @var array
     */
    protected $_mandatoryAttribs = array(
        Core_Form::CONTEXT_DEFAULT => array('id' => 'fullyQualifiedId', 'name' => 'fullyQualifiedName', 'cols', 'rows'),
        Core_Form::CONTEXT_ANGULAR => array('id' => 'fullyQualifiedAngularId', 'ng-model' => 'fullyQualifiedAngularModel', 'name', 'cols', 'rows'),
    );

    /**
     * @var array
     */
    protected $_defaultAttribs = array(
        Core_Form::CONTEXT_DEFAULT => array(),
        Core_Form::CONTEXT_ANGULAR => array('cf-form-element' => 'cf-form-element'),
    );

    /**
     * @var string
     */
    protected $_template = 'Core/Form/Element/Textarea.tpl';

    /**
     * @var string
     */
    protected $_macro    = 'element';

    /**
     * @param int $cols
     *
     * @return Core_Form_Element_Textarea
     */
    public function setCols($cols)
    {
        return $this->setAttrib('cols', $cols);
    }

    /**
     * @return int
     */
    public function getCols()
    {
        return $this->getAttrib('cols', 50);
    }

    /**
     * @param int $rows
     *
     * @return Core_Form_Element_Textarea
     */
    public function setRows($rows)
    {
        return $this->setAttrib('rows', $rows);
    }

    /**
     * @return int
     */
    public function getRows()
    {
        return $this->getAttrib('rows', 10);
    }
}
