<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category  Core
 * @package   Core_Form
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_Form_Element_Multiselect extends Core_Form_Element_MultiValue_Collection
{
    /**
     * @var array
     */
    protected $_defaultAttribs = array(
        Core_Form::CONTEXT_DEFAULT => array('multiple' => 'multiple'),
        Core_Form::CONTEXT_ANGULAR => array('cf-form-element' => 'cf-form-element', 'multiple' => 'multiple'),
    );

    protected $_prototypeType = 'select';

    /**
     * @var string
     */
    protected $_template = 'Core/Form/Element/MultiValue/Select.tpl';

    /**
     * @var string
     */
    protected $_macro    = 'element';

    /**
     * @return string
     */
    public function getFullyQualifiedName()
    {
        return parent::getFullyQualifiedName() .'[]';
    }

    public function populate(array $data)
    {
        if ($data) {
            $data = array_combine($data, array_fill(0, count($data), true));
        }
        return parent::populate($data);
    }

    public function getRawValues()
    {
        $rawValues = parent::getRawValues();
        return array_keys(array_filter($rawValues));
    }
}
