<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category  Core
 * @package   Core_Form
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
abstract class Core_Form_Element_MultiValue_Collection extends Core_Form_Element_Collection implements Core_Form_Element_MultiValue_Interface
{
    /**
     * @var array
     */
    protected $_possibleValues = array();

    /**
     * @param mixed $rawValue
     */
    public function setRawValue($rawValue)
    {
        if (empty($rawValue)) {
            $rawValue = array();
        }
        parent::setRawValue($rawValue);
    }

    /**
     * @param array $possibleValues
     *
     * @return \Core_Form_Element_Multivalue
     */
    public function setPossibleValues(array $possibleValues)
    {
        foreach($this->_possibleValues as $possibleValue => $label) {
            $this->removeElement($possibleValue);
        }

        foreach($possibleValues as $possibleValue => $label) {
            $element = $this->getElement($possibleValue);
            $element->setLabel($label);
        }
        $this->_possibleValues = $possibleValues;

        // auto-adding Inarray validator
        $this->_configureValidator('ArrayDiff', array('array' => array_keys($possibleValues)));

        return $this;
    }

    /**
     * @return array
     */
    public function getPossibleValues()
    {
        return $this->_possibleValues;
    }

    /**
     * @return array
     */
    protected function _getCollection()
    {
        return $this->getRawValues();
    }
}
