<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category  Core
 * @package   Core_Form
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
abstract class Core_Form_Element_MultiValue_Abstract extends Core_Form_Element_Abstract implements Core_Form_Element_MultiValue_Interface
{
    const VALUE_PLACEHOLDER = null;

    /**
     * @var array
     */
    protected $_possibleValues = array();

    /**
     * @param mixed $rawValue
     */
    public function setRawValue($rawValue)
    {
        if (empty($rawValue)) {
            $rawValue = self::VALUE_PLACEHOLDER;
        }
        parent::setRawValue($rawValue);
    }

    /**
     * @param array $possibleValues
     *
     * @return \Core_Form_Element_Multivalue
     */
    public function setPossibleValues(array $possibleValues)
    {
        $this->_possibleValues = $possibleValues;

        // auto-adding Inarray validator
        $allowedValues   = array_keys($possibleValues);
        // placeholder value should be allowed for this validator
        $allowedValues[] = self::VALUE_PLACEHOLDER;
        $this->_configureValidator('Inarray', array('array' => $allowedValues));

        return $this;
    }

    /**
     * @return array
     */
    public function getPossibleValues()
    {
        $possibleValues = array_map(array($this, '_translate'), $this->_possibleValues);
        return $possibleValues;
    }
}
