<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category  Core
 * @package   Core_Form
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
abstract class Core_Form_Element_Input extends Core_Form_Element_Abstract
{
    /**
     * @var array
     */
    protected $_mandatoryAttribs = array(
        Core_Form::CONTEXT_DEFAULT => array('id' => 'fullyQualifiedId', 'name' => 'fullyQualifiedName', 'value', 'type' => 'inputType'),
        Core_Form::CONTEXT_ANGULAR => array('id' => 'fullyQualifiedAngularId', 'ng-model' => 'fullyQualifiedAngularModel', 'name', 'type' => 'inputType'),
    );

    /**
     * @var array
     */
    protected $_defaultAttribs = array(
        Core_Form::CONTEXT_DEFAULT => array(),
        Core_Form::CONTEXT_ANGULAR => array('cf-form-element' => 'cf-form-element'),
    );

    /**
     * @var string
     */
    protected $_template = 'Core/Form/Element/Input.tpl';

    /**
     * @var string
     */
    protected $_macro    = 'element';

    /**
     * @var string
     */
    protected $_inputType;

    /**
     * @return string
     */
    public function getInputType()
    {
        return $this->_inputType;
    }
}
