<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category  Core
 * @package   Core_Form
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_Form_Element_Collection extends Core_Form_Entity_Collection implements Core_Form_Element_Interface
{
    /**
     * @var array
     */
    protected $_mandatoryAttribs = array(
        Core_Form::CONTEXT_DEFAULT => array('id' => 'fullyQualifiedId', 'name' => 'fullyQualifiedName'),
        Core_Form::CONTEXT_ANGULAR => array('id' => 'fullyQualifiedAngularId', 'ng-model' => 'fullyQualifiedAngularModel', 'name'),
    );

    /**
     * @var array
     */
    protected $_defaultAttribs = array(
        Core_Form::CONTEXT_DEFAULT => array(),
        Core_Form::CONTEXT_ANGULAR => array('cf-form-element' => 'cf-form-element'),
    );

    /**
     * @var int
     */
    protected $_initial = 0;

    /**
     * @var string
     */
    protected $_macro = 'element_collection';

    /**
     * @var string
     */
    protected $_type = 'element';

    /**
     * @var string
     */
    protected $_getItemsMethod = 'getElements';

    /**
     * @var string
     */
    protected $_getItemMethod  = 'getElement';

    /**
     * @var string
     */
    protected $_hasItemMethod  = 'hasElement';

    /**
     * @var string
     */
    protected $_addItemMethod  = 'addElement';

    /**
     * @var string
     */
    protected $_removeItemMethod  = 'removeElement';

    /**
     * @var string
     */
    protected $_createItemMethod  = 'createElement';

    /**
     * @return boolean
     */
    public function isInCollection()
    {
        $parent = $this->getParent();
        if (null === $parent) {
            return false;
        } else if (null === ($parent = $parent->getParent())) {
            return false;
        }
        return ($parent instanceof Core_Form_Group_Collection);
    }

    /**
     * @param string $context
     *
     * @return array
     */
    public function getAttribs($context = null)
    {
        $attribs = array_merge($this->getPrototypeInstance()->getAttribs(), $this->_getDefaultAttribs($context), $this->_attribs);
        unset($attribs['name']);
        $attribs = $this->_mergeMandatoryValues($attribs, $this->_mandatoryAttribs[$context]);
        if (Core_Form::CONTEXT_ANGULAR === $context) {
            $attribs = array_merge($attribs, $this->getAngularRepresentation(true));
        }
        return $attribs;
    }

    /**
     * @return array
     */
    public function getElements()
    {
        return $this->_getItems();
    }

    /**
     * @param int $idx
     *
     * @return Core_Form_Element_Interface
     */
    public function getElement($idx)
    {
        return $this->_getItem($idx);
    }

    /**
     * @param array $rawValue
     *
     * @return \Core_Form_Element_Collection
     */
    public function setRawValue($rawValue)
    {
        if (empty($rawValue)) {
            $rawValue = array();
        }
        $this->populateRaw($rawValue);
        return $this;
    }

    /**
     * @return array
     */
    public function getRawValue()
    {
        return $this->getRawValues();
    }

    /**
     * @param array $value
     *
     * @return \Core_Form_Element_Collection
     */
    public function setValue($value)
    {
        if (empty($value)) {
            $value = array();
        }
        $this->populate($value);
        return $this;
    }

    /**
     * @return array
     */
    public function getValue($key = '', $skipIgnored = true)
    {
        return $this->getValues();
    }

    /**
     * @return array
     */
    public function getError()
    {
        return $this->getErrors();
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->getPrototypeInstance()->getErrorMessage();
    }

    /**
     * @return string
     */
    public function getLabel()
    {
        return $this->getPrototypeInstance()->getLabel();
    }

    /**
     * @return string
     */
    public function getPlaceholder()
    {
        return $this->getPrototypeInstance()->getPlaceholder();
    }

    /**
     * @return boolean
     */
    public function isIgnored()
    {
        return $this->getPrototypeInstance()->isIgnored();
    }

    /**
     * @return boolean
     */
    public function isRequired()
    {
        return $this->getPrototypeInstance()->isRequired();
    }

    /**
     * @param string $template
     *
     * @return \Core_Form_Element_Collection
     */
    public function setTemplate($template)
    {
        $this->_template = $template;
        return $this;
    }

    /**
     * @return Twig_TemplateInterface
     */
    public function getTemplate()
    {
        if (!($this->_template instanceof Twig_TemplateInterface)) {
            $this->_template = $this->getView()->loadTemplate($this->_template);
        }
        return $this->_template;
    }

    /**
     * @return string
     */
    public function render($context = null)
    {
        $template = $this->getTemplate();
        $macro    = $this->getMacro();
        return $template->render(array('this' => $this, 'macro' => $macro, 'context' => $context));
    }
}
