<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category  Core
 * @package   Core_Form
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_Form_Element_Checkbox extends Core_Form_Element_Input
{
    /**
     * @var array
     */
    protected $_mandatoryAttribs = array(
        Core_Form::CONTEXT_DEFAULT => array('id' => 'fullyQualifiedId', 'name' => 'fullyQualifiedName', 'value' => 'checkedValue', 'checked' => 'checkedAttrib', 'type' => 'inputType'),
        Core_Form::CONTEXT_ANGULAR => array('id' => 'fullyQualifiedAngularId', 'ng-model' => 'fullyQualifiedAngularModel', 'name', 'type' => 'inputType'),
    );

    /**
     * @var array
     */
    protected $_defaultAttribs = array(
        Core_Form::CONTEXT_DEFAULT => array(),
        Core_Form::CONTEXT_ANGULAR => array('cf-form-element' => 'cf-form-element'),
    );

    /**
     * @var string
     */
    protected $_template = 'Core/Form/Element/Input/Checkbox.tpl';

    /**
     * @var string
     */
    protected $_macro    = 'element_label_behind';

    /**
     * @var string
     */
    protected $_inputType = 'checkbox';

    /**
     * @var boolean
     */
    protected $_checked = false;

    /**
     * @var mixed
     */
    protected $_checkedValue = true;

    /**
     * @var mixed
     */
    protected $_uncheckedValue = false;

    /**
     * @param boolean $checked
     *
     * @return \Core_Form_Element_Checkbox
     */
    public function setChecked($checked)
    {
        $this->_checked = (bool) $checked;
        return $this;
    }

    /**
     * @return boolean
     */
    public function isChecked()
    {
        return $this->_checked;
    }

    /**
     * @param mixed $checkedValue
     *
     * @return \Core_Form_Element_Checkbox
     */
    public function setCheckedValue($checkedValue)
    {
        $this->_checkedValue = $checkedValue;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getCheckedValue()
    {
        return $this->_checkedValue;
    }

    /**
     * @param mixed $uncheckedValue
     *
     * @return \Core_Form_Element_Checkbox
     */
    public function setUncheckedValue($uncheckedValue)
    {
        $this->_uncheckedValue = $uncheckedValue;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getUncheckedValue()
    {
        return $this->_uncheckedValue;
    }

    /**
     * @param mixed $rawValue
     *
     * @return \Core_Form_Element_Checkbox
     */
    public function setRawValue($rawValue)
    {
        $checkedValue = $this->getCheckedValue();
        if ($rawValue == $checkedValue) {
            parent::setRawValue($checkedValue);
            $this->setChecked(true);
        } else {
            parent::setRawValue($this->getUncheckedValue());
            $this->setChecked(false);
        }
        return $this;
    }

    /**
     * @return string
     */
    public function getCheckedAttrib()
    {
        if ($this->isChecked()) {
            return 'checked';
        }
    }
}
