<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category  Core
 * @package   Core_Form
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_Form_Element_Button extends Core_Form_Element_Abstract
{
    /**
     * @var string
     */
    protected $_template = 'Core/Form/Element/Button.tpl';

    /**
     * @var string
     */
    protected $_macro    = 'element_basic';

    /**
     * @var boolean
     */
    protected $_ignored  = true;

    /**
     * @param string $context
     *
     * @return array
     */
    protected function _getDefaultAttribs($context)
    {
        $attribs = parent::_getDefaultAttribs($context);
        if (isset($this->_attribs['type']) && 'submit' === $this->_attribs['type'] && Core_Form::CONTEXT_ANGULAR === $context) {
            $attribs = array_merge($attribs, array(
                'ng-click' => 'validate()'
            ));
        }
        return $attribs;
    }
}
