<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category  Core
 * @package   Core_Form
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 * @method    array                      getPlugins();                                      @see __call()
 * @method    Core_Form                  addPlugins(array $plugins);                        @see __call()
 * @method    Core_Form                  addPlugin(Core_Form_Plugin_Interface $plugin);     @see __call()
 * @method    Core_Form                  removePlugin($name);                               @see __call()
 * @method    Core_Form_Plugin_Interface createPlugin($type, $name, array $options = null); @see __call()
 * @method    Core_Form_Plugin_Interface getPlugin($name);                                  @see __call()
 * @method    boolean                    hasPlugin($name);                                  @see __call()
 */
class Core_Form extends Core_Form_Group_Abstract
{
    const CONTEXT_DEFAULT = 'default';
    const CONTEXT_ANGULAR = 'angular';

    /**
     * @var array
     */
    protected $_mandatoryAttribs = array(
        Core_Form::CONTEXT_DEFAULT => array('id' => 'fullyQualifiedId', 'action', 'method'),
        Core_Form::CONTEXT_ANGULAR => array('id' => 'fullyQualifiedAngularId', 'name', 'ng-model' => 'model'),
    );

    /**
     * @var Core_Request
     */
    protected $_request;

    /**
     * @var string
     */
    protected $_macro = 'form';

    /**
     * @param Zend_Config|array $options
     *
     * @return void
     */
    public function __construct($options = null)
    {
        $this->getPluginManager()
            ->addType('Core_Form_Plugin_Interface', 'FormPlugin', array(
                'mapping'  => array('Plugin' => 'Plugin', 'Plugins' => 'Plugins')
            ));

        parent::__construct($options);
    }
    
    /**
     * @return Zend_Translate
     */
    public function getTranslator()
    {
        if (null === $this->_translator) {
            if (Core_Application::has('translator')) {
                $this->_translator = Core_Application::get('translator');
            } else {
                $this->_translator = false;
            }
        }
        return $this->_translator;
    }

    /**
     * @param array $options
     *
     * @return Core_Form
     */
    public function setOptions(array $options)
    {
        if (isset($options['plugins'])) {
            $this->addPlugins($options['plugins']);
            unset($options['plugins']);
        }

        return parent::setOptions($options);
    }

    /**
     * @param Core_Request $request
     *
     * @return Core_Form
     */
    public function setRequest(Core_Request $request)
    {
        $this->_request = $request;
        return $this;
    }

    /**
     * @return Core_Request
     */
    public function getRequest()
    {
        if (null === $this->_request) {
            $this->setRequest(Core_Application::get('Request'));
        }
        return $this->_request;
    }

    /**
     * @param string $method
     *
     * @return \Core_Form
     */
    public function setMethod($method)
    {
        $this->setAttrib('method', $method);
        return $this;
    }

    /**
     * @return string
     */
    public function getMethod()
    {
        $method = $this->getAttrib('method');
        if (null === $method) {
            $method = 'post';
        }
        return $method;
    }

    /**
     * @param string $action
     *
     * @return \Core_Form
     */
    public function setAction($action)
    {
        $this->setAttrib('action', $action);
        return $this;
    }

    /**
     * @return string
     */
    public function getAction()
    {
        $action = $this->getAttrib('action');
        if (null === $action) {
            $action = $this->getRequest()->getUri();
        }
        return $action;
    }

    /**
     * @param string $context
     * 
     * @return array
     */
    protected function _getDefaultAttribs($context)
    {
        $attribs = parent::_getDefaultAttribs($context);
        if (self::CONTEXT_ANGULAR === $context) {
            $model   = $this->getModel();
            $attribs = array_merge($attribs, array(
                'errors'          => $model . 'Errors',
                'submit-callback' => sprintf('submit(%s)', $model),
            ));
        }
        return $attribs;
    }
}
