<?php
class Core_Filter_Url extends Core_Filter_Abstract
{
    public function filter($value)
    {
        if ($value) {
            // two cases

            // 1. if no protocol in URL, prepend http:// to it
            if (!preg_match('|^[a-z]+://|i', $value)) {
                $value = 'http://'. $value;
            }

            // 2. if we have a trailing slash after the domain as the last char, strip it
            if (preg_match('|^([a-z]+://[^/]+)/$|i', $value, $matches)) {
                $value = $matches[1];
            }
        }

        return $value;
    }
}