<?php
/**
 * core.framework
 *
 * @category  Core
 * @package   Core_Filter
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */

/**
 * @category  Core
 * @package   Core_Filter
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_Filter_Transliterate extends Core_Filter_Abstract
{
    /**
     * @param mixed $value Value to filter
     *
     * @return mixed Transliterated value.
     */
    public function filter($value)
    {
        $value    = str_replace(array('Đ', 'đ'), array('Dj', 'dj'), $value);
        $translit = iconv('UTF-8', 'ASCII//TRANSLIT//IGNORE', $value);
        return $translit;
    }
}