<?php
class Core_Filter_Markup extends Core_Filter_Abstract
{
    protected $_purifier;
    protected $_preset = 'default';

    public function filter($value)
    {
        // bail early if the value is empty (there's nothing to purify)
        if (empty($value)) {
            // we return value to retain it's type
            return $value;
        }

        $purifier = $this->getPurifier();
        return $purifier->purify($value);
    }

    public function setPurifier(HTMLPurifier $purifier)
    {
        $this->_purifier = $purifier;
        return $this;
    }

    public function getPurifier()
    {
        if (null === $this->_purifier) {
            $this->_purifier = Core_Application::get('htmlPurifier',
                    array('htmlPurifierPreset' => $this->getPreset()));
        }
        return $this->_purifier;
    }

    public function setPreset($preset)
    {
        // reset the purifier when doing this so new config takes effect
        $this->_purifier = null;

        $this->_preset   = $preset;
        return $this;
    }

    public function getPreset()
    {
        return $this->_preset;
    }
}