<?php
abstract class Core_Filter_Abstract implements Core_Filter_Interface
{
    protected $_type;
    protected $_name;

    public function __construct($options = array())
    {
        $this->setOptions($options);
    }

    public function init()
    {}

    public function setOwner(Core_Plugin_Interface $owner)
    {}

    public function setName($name)
    {
        $this->_name = $name;
        return $this;
    }

    public function getName()
    {
        return $this->_name;
    }

    public function setOptions(array $options)
    {
        foreach ($options as $name => $value) {
            $normalized = ucfirst($name);

            $method = 'set' . $normalized;
            if (method_exists($this, $method)) {
                $this->$method($value);
            } else {
                trigger_error(sprintf('Invalid param: %s::$%s', get_class($this), $name), E_USER_NOTICE);
            }
        }
        return $this;
    }
}