<?php
interface Core_Event_Dispatcher_Interface
{
    public function setEventSubscribers($eventName, array $eventSubscribers);
    public function hasEventSubscribers($eventName);
    public function getEventSubscribers($eventName);

    public function subscribe($eventName, $callback, $priority = 0);
    public function unsubscribe($eventName, $callback = null);

    public function dispatch(Core_Event_Interface $event);
    public function dispatchUntil(Core_Event_Interface $event);
    public function filter(Core_Event_Interface $event, $value);
}