<?php
/**
 * core.framework
 *
 * @category  Core
 * @package   Core_Event
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */

/**
 * @category  Core
 * @package   Core_Event
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_Event implements Core_Event_Interface
{
    /**
     * @var string Event name
     */
    protected $_name;

    /**
     * @var mixed Event subject (what created the event)
     */
    protected $_subject;

    /**
     * @var array Event params
     */
    protected $_params;

    /**
     * @var boolean Is the event processed yet?
     */
    protected $_processed = false;

    /**
     * @var boolean Is the event processed yet?
     */
    protected $_propagated = true;

    /**
     * @param mixed  $subject Event subject
     * @param string $name    Event name
     * @param array  $params  Event params
     */
    public function  __construct($subject, $name, $params = array())
    {
        $this
            ->setSubject($subject)
            ->setName($name)
            ->setParams($params);
    }

    /**
     * @param string $name
     *
     * @return Core_Event
     */
    public function setName($name)
    {
        $this->_name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->_name;
    }

    /**
     * @param mixed $subject
     *
     * @return Core_Event
     */
    public function setSubject($subject)
    {
        $this->_subject = $subject;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getSubject()
    {
        return $this->_subject;
    }

    /**
     * @param boolean $isProcessed
     *
     * @return Core_Event
     */
    public function setIsProcessed($isProcessed = true)
    {
        $this->_processed = (bool) $isProcessed;
        return $this;
    }

    /**
     * @return boolean
     */
    public function isProcessed()
    {
        return $this->_processed;
    }

    /**
     * @param boolean $isPropagated
     *
     * @return Core_Event
     */
    public function setIsPropagated($isPropagated = true)
    {
        $this->_propagated = (bool) $isPropagated;
        return $this;
    }

    /**
     * @return boolean
     */
    public function isPropagated()
    {
        return $this->_propagated;
    }

    /**
     * @param array $params
     *
     * @return Core_Event
     */
    public function setParams(array $params)
    {
        $this->_params = $params;
        return $this;
    }

    /**
     * @return array
     */
    public function getParams()
    {
        return $this->_params;
    }

    /**
     * @param string $name  Param name
     * @param mixed  $value Param value
     *
     * @return Core_Event
     */
    public function setParam($name, $value)
    {
        $this->_params[$name] = $value;
        return $this;
    }

    /**
     * @param string $name
     *
     * @return type
     */
    public function hasParam($name)
    {
        return isset($this->_params[$name]);
    }

    /**
     * @param string $name
     *
     * @return mixed
     */
    public function getParam($name)
    {
        if ($this->hasParam($name)) {
            $value = $this->_params[$name];
        } else {
            $value = null;
        }
        return $value;
    }
}
